package com.tangguo.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.domain.vo.BbsCommentDetailVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 动态评论记录Mapper接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface BbsMomentCommentMapper extends BaseMapper<BbsMomentComment> {


	List<BbsMomentComment> selectBbsMomentCommentList(@Param("comment") BbsMomentComment comment);


	List<BbsMomentComment> selectBbsMomentComments(@Param("commentId") Long commentId);


	List<BbsMomentComment> selectBbsComments(@Param("momentId") Long momentId);


	List<BbsMomentComment> selectMomentLimitComments(@Param("momentIds") List<Long> momentIds,
	                                                 @Param("rows") int rows,
	                                                 @Param("userName") String userName);


	List<BbsCommentDetailVO> selectMomentComments(@Param("momentId") Long momentId,
	                                              @Param("userName") String userName);

}
