package com.tangguo.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 积分配置类型
 *
 * @author 谈笑
 * @createTime 2025-09-01 10:14:35 星期一
 */
@Getter
@AllArgsConstructor
public enum PointsSettingType {

	ADD("增加积分"), DEC("减少积分");

	private final String desc;


	public static PointsSettingType getSettingType(String type) {
		return Arrays.stream(PointsSettingType.values())
			.filter(t -> t.name().equals(type)).findFirst().orElse(null);
	}

}
