import request from '@/utils/request'

// 积分管理列表
export function listData(params) {
    return request({
        url: '/bbs/points/user/points/list',
        method: 'get',
        params
    })
}

// 积分明细
export function detailData(params) {
    return request({
        url: `/bbs/points/user/points/details`,
        method: 'get',
        params
    })
}
// 积分详情
export function pointsDetail(userName){
    return request({
        url:`/bbs/points/user/points/${userName}`,
        method: 'get',
    })
}

// 导出用户
export function exportUser(data){
    return request({
        url:'/bbs/points/user/points/export',
        method:'post',
        data
    })
}

// 增加积分
export function addData(data) {
    return request({
        url: '/bbs/points/user/points/incr',
        method: 'put',
        data
    })
}

// 扣减积分
export function editData(data) {
    return request({
        url: '/bbs/points/user/points/decr',
        method: 'put',
        data
    })
}

// 积分配置规则
export function pointsSetting(params){
    return request({
        url:'/bbs/points/setting/details',
        method:'get',
        params
    })
}


// 修改积分配置
export function updatePointsSetting(data){
    return request({
        url:'/bbs/points/setting/batch',
        method:'put',
        data
    })
}

// 批量增加积分
export function batchAddPoints(data){
    return request({
        url:'/bbs/points/user/points/batch/incr',
        method:'put',
        data
    })
}
