package com.tangguo.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.common.enums.CommentStatus;
import com.tangguo.common.exception.ServiceException;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.domain.bo.FeaturedCommentBO;
import com.tangguo.domain.vo.BbsCommentDetailVO;
import com.tangguo.mapper.BbsMomentCommentMapper;
import com.tangguo.service.IBbsMomentCommentService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 动态评论记录Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Service
public class BbsMomentCommentServiceImpl extends ServiceImpl<BbsMomentCommentMapper, BbsMomentComment> implements IBbsMomentCommentService {

    @Resource
    private BbsMomentCommentMapper bbsMomentCommentMapper;


    /**
     * 查询动态评论记录列表
     *
     * @param comment 动态评论记录
     * @return 动态评论记录
     */
    @Override
    public List<BbsMomentComment> selectBbsMomentCommentList(BbsMomentComment comment) {
        return this.baseMapper.selectBbsMomentCommentList(comment);
    }


    /**
     * 查询动态评论记录详情
     *
     * @param commentId 动态评论记录Id
     * @return 动态评论记录详情
     */
    @Override
    public BbsMomentComment getBbsMomentComment(Long commentId) {
        BbsMomentComment dbComment = this.getById(commentId);
        if (Objects.nonNull(dbComment)) {
            List<BbsMomentComment> comments = this.baseMapper.selectBbsMomentComments(commentId);
            dbComment.setComments(comments);
        }
        return dbComment;
    }


    /**
     * 删除评论
     *
     * @param commentId 评论Id
     */
    @Override
    public void deleteComment(Long commentId) {
        BbsMomentComment dbComment = this.getById(commentId);
        if (Objects.isNull(dbComment)) {
            throw new ServiceException("删除失败，未查询到当前评论数据。");
        }

        BbsMomentComment updComment = new BbsMomentComment();
        updComment.setId(dbComment.getId());
        updComment.setStatus(CommentStatus.SC.getStatus());
        updComment.setDeleteComment("该评论已被删除");
        this.updateById(updComment);
    }


    /**
     * 查询动态评论
     *
     * @param momentIds 动态Ids
     * @param userName 用户名
     * @return 投票选项
     */
    @Override
    public List<BbsMomentComment> getMomentLimitComments(List<Long> momentIds, String userName) {
        List<BbsMomentComment> dbComments = new ArrayList<>(30);
        if (CollUtil.isNotEmpty(momentIds)) {
            dbComments = this.baseMapper.selectMomentLimitComments(momentIds, 3, userName);
        }
        return dbComments;
    }


    /**
     * 查询动态评论
     *
     * @param momentId 动态Id
     * @param userName 用户名
     * @return 评论
     */
    @Override
    public List<BbsCommentDetailVO> getMomentComments(Long momentId, String userName) {
        return this.baseMapper.selectMomentComments(momentId, userName);
    }

}
