package com.tangguo.common.listener;

import cn.hutool.core.util.IdUtil;
import com.tangguo.common.constant.ActiveMQConstant;
import com.tangguo.common.domain.OperateDetail;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

import javax.annotation.Resource;

/**
 * 操作事件监听器
 *
 * @author 谈笑
 * @createTime 2025-09-09 11:26:28 星期二
 */
@Slf4j
@Component
public class OperateEventListener {

	@Resource
	private JmsTemplate jmsTemplate;


	/**
	 * 处理用户操作事件
	 *
	 * @param event 事件对象
	 */
	@TransactionalEventListener(classes = OperateEvent.class, fallbackExecution = true)
	public void handle(OperateEvent event) {
		OperateDetail detail = new OperateDetail();
		detail.setLinkTracId(IdUtil.fastUUID());
		detail.setUserName(event.getUserName());
		detail.setOperateCode(event.getOperateType().getCode());
		log.info("=> 开始处理用户操作事件：{}", detail);
		this.jmsTemplate.convertAndSend(ActiveMQConstant.Operate.USER_OPERATE, detail);
	}

}
