package com.tangguo.domain.vo;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-03 15:42:59 星期三
 */
@Data
public class BbsMomentListVO {

	/** 发布时间 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createTime;

	/** 动态Id */
	private Long id;

	/** 发布人用户姓名 */
	private String nickName;

	/** 发布人用户名 */
	private String userName;

	/** 动态内容 */
	private String content;

	/** 动态类型：IMAGE 图片动态、VIDEO 视频动态、URL 链接动态 */
	private String type;

	/** 话题名称 */
	private List<String> topicNames;

	/** 话题Ids */
	private List<String> topicIds;

	/** 外部链接地址 */
	private String linkUrl;

	/** 是否开启评论：0 否、1 是 */
	private Integer isEnableComment;

	/** 是否精选评论：0 否、1 是 */
	private Integer isEnableFeaturedComment;

	/** 是否开启投票：0 否、1 是 */
	private Integer isEnableVote;

	/** 投票标题 */
	private String voteTitle;

	/** 投票选项类型：TEXT 文字、IMAGE 图片 */
	private String voteOptionType;

	/** 动态点赞人数 */
	private Integer likeCount;

	/** 动态评论人数 */
	private Integer commentCount;

	/** 动态投票人数 */
	private Integer voteCount;

	/** 当前是否点赞：0 未点赞、1 已点赞 */
	private Integer isLike;

	/** 当前是否投票：0 未投票、1 已投票 */
	private Integer isVote;

	/** 是否本人动态：0 否、1 是 */
	private Integer isSelf;

	/** 动态附件 */
	private List<BbsAttachmentVO> attachments;

	/** 动态投票选项 */
	private List<BbsVoteOptionVO> voteOptions;

	/** 动态评论 */
	private List<BbsCommentVO> comments;


	/**
	 * 处理主题名称
	 */
	public void setTopicNames(String topicNames) {
		if (StrUtil.isNotBlank(topicNames)) {
			this.topicNames = Arrays.asList(topicNames.split(","));
		}
	}


	/**
	 * 处理主题Id
	 */
	public void setTopicIds(String topicIds) {
		if (StrUtil.isNotBlank(topicIds)) {
			this.topicIds = Arrays.asList(topicIds.split(","));
		}
	}

}
