package com.tangguo.domain.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 数据导入结果
 *
 * @author 谈笑
 * @createTime 2025-08-28 09:43:53 星期四
 */
@Data
public class DataImportResult<T> implements Serializable {

	private static final long serialVersionUID = -1544586244818112713L;

	/**
	 * 导入任务Id
	 */
	private String taskId;

	/**
	 * 导入数据总条数
	 */
	private int totalCount;

	/**
	 * 导入成功数据条数
	 */
	private int successCount;

	/**
	 * 导入失败数据条数
	 */
	private int failCount;

	/**
	 * 导入失败消息
	 */
	private String errorMessage;

	/**
	 * 导入数据失败数据明细
	 */
	private List<Row<T>> failRows = new ArrayList<>(0);


	@Data
	public static class Row<T> implements Serializable {

		private static final long serialVersionUID = -437773899860737658L;

		/**
		 * 原始数据
		 */
		private T rowData;

		/**
		 * 反馈消息
		 */
		private String message;

	}

}
