import request from '@/utils/request'

// 话题列表
export function listData(params) {
    return request({
        url: '/bbs/moment/topic/list',
        method: 'get',
        params
    })
}

// 话题详情
export function detailData(id) {
    return request({
        url: `/bbs/moment/topic/${id}`,
        method: 'get'
    })
}

// 新增话题
export function addData(data) {
    return request({
        url: '/bbs/moment/topic',
        method: 'post',
        data
    })
}

// 修改话题
export function editData(data) {
    return request({
        url: '/bbs/moment/topic',
        method: 'put',
        data
    })
}

// 置顶话题
export function setTop(data) {
    return request({
        url: '/bbs/moment/topic/top',
        method: 'put',
        data
    })
}

// 删除话题
export function delData(id) {
    return request({
        url: `/bbs/moment/topic/${id}`,
        method: 'delete'
    })
}
