package com.tangguo.web.controller.monitor;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.constant.CacheConstants;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.domain.model.LoginUser;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.core.redis.RedisCache;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.StringUtils;
import com.tangguo.system.domain.SysUserOnline;
import com.tangguo.system.service.ISysUserOnlineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 在线用户监控
 *
 * @author ruoyi
 */
@RestController
@RequestMapping("/monitor/online")
public class SysUserOnlineController extends BaseController {
	@Autowired
	private ISysUserOnlineService userOnlineService;

	@Autowired
	private RedisCache redisCache;

	@PreAuthorize("@ss.hasPermi('monitor:online:list')")
	@GetMapping("/list")
	public TableDataInfo list(String ipaddr, String userName) {
		Collection<String> keys = redisCache.keys(CacheConstants.LOGIN_TOKEN_KEY + "*");
		List<SysUserOnline> userOnlineList = new ArrayList<SysUserOnline>();
		for (String key : keys) {
			LoginUser user = redisCache.getCacheObject(key);
			if (Objects.isNull(user)) {
				continue;
			}
			if (StringUtils.isNotEmpty(ipaddr) && StringUtils.isNotEmpty(userName)) {
				userOnlineList.add(userOnlineService.selectOnlineByInfo(ipaddr, userName, user));
			} else if (StringUtils.isNotEmpty(ipaddr)) {
				userOnlineList.add(userOnlineService.selectOnlineByIpaddr(ipaddr, user));
			} else if (StringUtils.isNotEmpty(userName) && StringUtils.isNotNull(user.getUser())) {
				userOnlineList.add(userOnlineService.selectOnlineByUserName(userName, user));
			} else {
				userOnlineList.add(userOnlineService.loginUserToUserOnline(user));
			}
		}
		Collections.reverse(userOnlineList);
		userOnlineList.removeAll(Collections.singleton(null));
		return getDataTable(userOnlineList);
	}

	/**
	 * 强退用户
	 */
	@PreAuthorize("@ss.hasPermi('monitor:online:forceLogout')")
	@Log(title = "在线用户", businessType = BusinessType.FORCE)
	@DeleteMapping("/{tokenId}")
	public AjaxResult forceLogout(@PathVariable String tokenId) {
		redisCache.deleteObject(CacheConstants.LOGIN_TOKEN_KEY + tokenId);
		return success();
	}
}
