package com.tangguo.web.controller.system;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.tangguo.common.annotation.Log;
import com.tangguo.common.constant.Constants;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.domain.entity.SysMenu;
import com.tangguo.common.core.domain.entity.SysRole;
import com.tangguo.common.core.domain.entity.SysUser;
import com.tangguo.common.core.domain.model.LoginBody;
import com.tangguo.common.core.domain.model.LoginUser;
import com.tangguo.common.core.domain.model.WxcpCodeLogin;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.exception.ServiceException;
import com.tangguo.common.utils.SecurityUtils;
import com.tangguo.common.utils.StringUtils;
import com.tangguo.framework.config.ServerConfig;
import com.tangguo.framework.web.service.SysLoginService;
import com.tangguo.framework.web.service.SysPermissionService;
import com.tangguo.framework.web.service.TokenService;
import com.tangguo.framework.web.service.UserDetailsServiceImpl;
import com.tangguo.system.service.ISysMenuService;
import com.tangguo.system.service.ISysUserService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 登录验证
 *
 * @author ruoyi
 */
@Slf4j
@RestController
public class SysLoginController {
	@Autowired
	private SysLoginService loginService;

	@Autowired
	private ISysMenuService menuService;

	@Autowired
	private SysPermissionService permissionService;

	@Autowired
	private UserDetailsServiceImpl userDetailsServiceImpl;

	@Autowired
	private TokenService tokenService;

	@Autowired
	private WxCpService wxCpService;

	@Autowired
	private ServerConfig serverConfig;

	@Autowired
	private ISysUserService userService;

	@Value("${wx.cp.redirect-url}")
	private String redirectUrl;



	/**
	 * 登录方法
	 *
	 * @param loginBody 登录信息
	 * @return 结果
	 */
	@PostMapping("/login")
	public AjaxResult login(@RequestBody LoginBody loginBody) {
		AjaxResult ajax = AjaxResult.success();
		// 生成令牌
		String token = loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(),
				loginBody.getUuid());
		ajax.put(Constants.TOKEN, token);
		return ajax;
	}

	/**
	 * 获取用户信息
	 *
	 * @return 用户信息
	 */
	@GetMapping("getInfo")
	public AjaxResult getInfo() {
		SysUser user = SecurityUtils.getLoginUser().getUser();
		// 角色集合
		Set<String> roles = permissionService.getRolePermission(user);
		// 权限集合
		Set<String> permissions = permissionService.getMenuPermission(user);
		AjaxResult ajax = AjaxResult.success();
		ajax.put("user", user);
		ajax.put("roles", roles);
		ajax.put("permissions", permissions);
		return ajax;
	}

	/**
	 * 获取路由信息
	 *
	 * @return 路由信息
	 */
	@GetMapping("getRouters")
	public AjaxResult getRouters() {
		Long userId = SecurityUtils.getUserId();
		List<SysMenu> menus = menuService.selectMenuTreeByUserId(userId);
		return AjaxResult.success(menuService.buildMenus(menus));
	}




	/**
	 * 企微用户Code登录
	 *
	 * @param bo 登录参数
	 * @return 登录结果
	 */
	@PostMapping("/bbs/mobile/user/code/login")
	public AjaxResult codeLogin(@RequestBody WxcpCodeLogin bo) {
		LoginUser loginUser = SecurityUtils.getLoginUserNotEx();
		log.info("=> 登录请求参数：{}", bo);
		log.info("=> 当前登录用户：{}", loginUser);

		// 企微登录认证链接
		String authCode = bo.getCode();
		WxCpOAuth2Service oauth2Service = this.wxCpService.getOauth2Service();
		if (Objects.isNull(loginUser) && StrUtil.isBlank(authCode)) {
			String oauth2Url = oauth2Service.buildAuthorizationUrl(this.redirectUrl, null);
			log.info("=> 认证失败，返回Oauth2登录链接：{}", oauth2Url);
			return AjaxResult.error(401, "身份认证失败", oauth2Url);
		}

		// 查询企微用户信息
		String token = null;
		if (Objects.isNull(loginUser) && StrUtil.isNotBlank(authCode)) {
			try {
				WxCpOauth2UserInfo userInfo = oauth2Service.getUserInfo(authCode);
				log.info("=> 查询企微用户信息，返回结果：{}，{}", authCode, JSON.toJSONString(userInfo));
				UserDetails userDetails = this.userDetailsServiceImpl.loadUserByUsername2(userInfo.getUserId());
				token = this.tokenService.createToken((LoginUser) userDetails);
			} catch (Exception e) {
				log.error("=> 查询用户信息失败：", e);
				throw new ServiceException("登录失败，查询用户信息失败。");
			}
		}

		log.info("=> 登录结果：{}", token);
		return AjaxResult.success("登录成功", token);
	}


	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@GetMapping("/bbs/mobile/user/profile")
	public AjaxResult getUserProfile() {
		log.info("=> 查询用户信息，当前登录用户名：{}", SecurityUtils.getUsername());
		final String bbsAdmin = "bbs_admin";
		SysUser sysUser = SecurityUtils.getLoginUser().getUser();
		List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
		boolean anyMatch = roles.stream().anyMatch(r -> bbsAdmin.equals(r.getRoleKey()));
		sysUser.setBbsAdmin(anyMatch);
		return AjaxResult.success(sysUser);
	}



	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@PutMapping("/bbs/mobile/user/profile")
	public AjaxResult updateUserProfile(@RequestBody SysUser user) {
		LoginUser loginUser = SecurityUtils.getLoginUser();
		SysUser updUser = new SysUser();
		updUser.setUserId(loginUser.getUserId());
		updUser.setAvatar(user.getAvatar());
		if (this.userService.updateUserProfile(updUser) > 0) {
			SysUser sysUser = loginUser.getUser();
			sysUser.setAvatar(user.getAvatar());
			tokenService.setLoginUser(loginUser);
			return AjaxResult.success();
		}
		return AjaxResult.error("修改失败");
	}

}
