import request from '@/utils/request.js'

// 用户动态统计--我的页面
export function getDynamicStastics() {
	return request({
		url: 'user/moment/count',
		method: 'get'
	})
}

//用户动态列表
 export function userDynamics(params){
	 return request({
		 url:'user/moments',
		 method: 'get',
		 params
	 })
 }

// 选择话题
export function getTopicSelection(params) {
	return request({
		url: 'topic/select',
		method: 'get',
		params
	})
}

// 创建话题
export function createNewTopic(data) {
	return request({
		url: 'topic/create',
		method: 'post',
		data
	})
}

// 热搜话题
export function hotTopicRanking(params) {
	return request({
		url: 'topic/ranking',
		method: 'get',
		params
	})
}

// 话题详情
export function topicDetail(params) {
	return request({
		url: 'topic/details',
		method: 'get',
		params
	})
}
// 话题动态
export function topicDynamics(params) {
	return request({
		url: 'topic/moments',
		method: 'get',
		params
	})
}

// 创建动态
export function crateNewDynamic(data) {
	return request({
		url: 'moment/create',
		method: 'post',
		data
	})
}

// 动态列表
export function dynamicList(params){
	return request({
		url: 'moment/moments',
		method: 'get',
		params
	})
}

// 动态点赞/取消点赞
export function dynamicLikeUnlike(data){
	return request({
		url:'moment/like',
		method:'post',
		data
	})
}
// 发布动态评论
export function publishComment(data){
	return request({
		url:'moment/comment',
		method:'post',
		data
	})
}

// 动态详情
export function dynamicDetail(id){
	return request({
		url:`moment/${id}`,
		method:'get'
	})
}

// 动态详情评论列表
export function dynamicDetailComments(params){
	return request({
		url:'moment/comments',
		method:'get',
		params
	})
}

// 动态投票
export function dynamicVote(data){
	return request({
		url:'moment/vote',
		method:'post',
		data
	})
}

// 投票列表
export function voteList(params){
	return request({
		url:'moment/votes',
		method:'get',
		params
	})
}

// 评论精选,取消精选
export function commentFeatured(data){
	return request({
		url:'moment/comment/featured',
		method:'post',
		data
	})
}

// 删除评论
export function delComment(commentId){
	return request({
		url:`moment/comment/delete/${commentId}`,
		method:'delete'
	})
}

// 删除动态
export function delMonment(momentId){
	return request({
		url:`moment/delete/${momentId}`,
		method:'delete'
	})
}

// 修改用户信息
export function updateUserInfo(data){
	return request({
		url:'user/profile',
		method:'put',
		data
	})
}