package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentComment;

import java.util.List;

/**
 * 动态评论记录Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsMomentCommentService extends IService<BbsMomentComment> {

    /**
     * 查询动态评论记录列表
     *
     * @param comment 动态评论记录
     * @return 动态评论记录集合
     */
    List<BbsMomentComment> selectBbsMomentCommentList(BbsMomentComment comment);


    /**
     * 查询动态评论记录详情
     *
     * @param commentId 动态评论记录Id
     * @return 动态评论记录详情
     */
    BbsMomentComment getBbsMomentComment(Long commentId);


    /**
     * 删除评论
     *
     * @param commentId 评论Id
     */
    void deleteComment(Long commentId);

}
