package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.domain.BbsPointsGoods;
import com.tangguo.service.IBbsPointsGoodsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 积分商品Controller
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Api(tags = "积分商品管理")
@RestController
@RequestMapping("/bbs/points/goods")
public class BbsPointsGoodsController extends BaseController {

	@Resource
	private IBbsPointsGoodsService bbsPointsGoodsService;


	/**
	 * 查询积分商品列表
	 */
	@ApiOperation("查询积分商品列表")
	@GetMapping("/list")
	public TableDataInfo list(BbsPointsGoods bbsPointsGoods) {
		startPage();
		List<BbsPointsGoods> list = bbsPointsGoodsService.selectBbsPointsGoodsList(bbsPointsGoods);
		return getDataTable(list);
	}


	/**
	 * 获取积分商品详细信息
	 */
	@ApiOperation("获取积分商品详细信息")
	@PreAuthorize("@ss.hasPermi('goods:goods:query')")
	@GetMapping(value = "/{code}")
	public AjaxResult getInfo(@PathVariable("code") String code) {
		BbsPointsGoods dbGoods = this.bbsPointsGoodsService.getByGoodsCode(code);
		return success(bbsPointsGoodsService.getById(dbGoods));
	}


	/**
	 * 新增积分商品
	 */
	@ApiOperation("新增积分商品")
	@PreAuthorize("@ss.hasPermi('goods:goods:add')")
	@Log(title = "积分商品", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody BbsPointsGoods goods) {
		this.bbsPointsGoodsService.addGoods(goods);
		return AjaxResult.success();
	}


	/**
	 * 修改积分商品
	 */
	@ApiOperation("修改积分商品")
	@PreAuthorize("@ss.hasPermi('goods:goods:edit')")
	@Log(title = "积分商品", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody BbsPointsGoods goods) {
		this.bbsPointsGoodsService.editGoods(goods);
		return AjaxResult.success();
	}


	/**
	 * 删除积分商品
	 */
	@ApiOperation("删除积分商品")
	@PreAuthorize("@ss.hasPermi('goods:goods:remove')")
	@Log(title = "积分商品", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
	public AjaxResult remove(@PathVariable Long id) {
		this.bbsPointsGoodsService.deleteGoods(id);
		return AjaxResult.success();
	}

}
