package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 动态对象 bbs_moment
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment")
@ApiModel(value = "BbsMoment", description = "动态实体")
public class BbsMoment extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 发布人用户名 */
	@Excel(name = "用户名", sort = 2)
	private String userName;

	/** 动态内容 */
	@Excel(name = "动态内容", sort = 4)
	@ApiModelProperty("动态内容")
	private String content;

	/** 动态类型：IMAGE 图片动态、VIDEO 视频动态、URL 链接动态 */
	@ApiModelProperty("动态类型：IMAGE 图片动态、VIDEO 视频动态、URL 链接动态")
	private String type;

	/** 话题名称（逗号分割） */
	@Excel(name = "话题名称", sort = 5)
	@ApiModelProperty("话题名称（逗号分割）")
	private String topicNames;

	/** 话题Ids（逗号分割） */
	@ApiModelProperty("话题Ids（逗号分割）")
	private String topicIds;

	/** 外部链接地址 */
	@ApiModelProperty("外部链接地址")
	private String linkUrl;

	/** 是否开启评论：0 否、1 是 */
	@ApiModelProperty("是否开启评论：0 否、1 是")
	private Integer isEnableComment;

	/** 是否精选评论：0 否、1 是 */
	@ApiModelProperty("是否精选评论：0 否、1 是")
	private Integer isEnableFeaturedComment;

	/** 是否开启投票：0 否、1 是 */
	@ApiModelProperty("是否开启投票：0 否、1 是")
	private Integer isEnableVote;

	/** 投票标题 */
	@ApiModelProperty("投票标题")
	private String voteTitle;

	/** 投票选项类型：TEXT 文字、IMAGE 图片 */
	@ApiModelProperty("投票选项类型：TEXT 文字、IMAGE 图片")
	private String voteOptionType;

	/** 投票开始时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty("投票开始时间")
	private Date voteStartTime;

	/** 投票结束时间 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty("投票结束时间")
	private Date voteEndTime;

	/** 动态点赞人数 */
	@Excel(name = "点赞数", sort = 6)
	@ApiModelProperty("动态点赞人数")
	private Integer likeCount;

	/** 动态评论人数 */
	@Excel(name = "评论数", sort = 7)
	@ApiModelProperty("动态评论人数")
	private Integer commentCount;

	/** 动态投票人数 */
	@ApiModelProperty("动态投票人数")
	private Integer voteCount;


    /** 用户姓名 */
    @Excel(name = "姓名", sort = 1)
    @TableField(exist = false)
    private String nickName;

    /** 用户部门 */
    @Excel(name = "部门(班级)", sort = 3)
    @TableField(exist = false)
    private String deptName;

	@TableField(exist = false)
	private String ancestors;

	@Excel(name = "上级部门(学院)", sort = 4)
	@TableField(exist = false)
	private String fullDeptName;


	/** 动态附件 */
	@TableField(exist = false)
	private List<BbsMomentAttachment> attachments;

}
