package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 话题对象 bbs_topic
 *
 * @author ruoyi
 * @date 2025-08-27
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_topic")
@ApiModel(value = "BbsTopic", description = "话题实体")
public class BbsTopic extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 话题来源 */
	@Excel(name = "话题来源")
	@ApiModelProperty("话题来源")
	private String source;

	/** 话题名称 */
	@Excel(name = "话题名称")
	@ApiModelProperty("话题名称")
	private String name;

	/** 排序值（升序） */
	@Excel(name = "排序值", readConverterExp = "升=序")
	@ApiModelProperty("排序值（升序）")
	private Integer sort;

	/** 是否置顶：0 否、1 是 */
	@Excel(name = "是否置顶：0 否、1 是")
	@ApiModelProperty("是否置顶：0 否、1 是")
	private Integer isTop;

	/** 置顶时间（降序） */
	@Excel(name = "置顶时间", readConverterExp = "降=序")
	@ApiModelProperty("置顶时间（降序）")
	private Date topTime;

	/** 话题动态总点赞数 */
	@Excel(name = "话题动态总点赞数")
	@ApiModelProperty("话题动态总点赞数")
	private Integer likeCount;

	/** 话题动态总评论数 */
	@Excel(name = "话题动态总评论数")
	@ApiModelProperty("话题动态总评论数")
	private Integer commentCount;

	/** 话题热度 */
	@Excel(name = "话题热度")
	@ApiModelProperty("话题热度")
	private Integer heat;

}
