package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsUserPointsDetail;
import com.tangguo.mapper.BbsUserPointsDetailMapper;
import com.tangguo.service.IBbsUserPointsDetailService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户积分明细Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Service
public class BbsUserPointsDetailServiceImpl extends ServiceImpl<BbsUserPointsDetailMapper, BbsUserPointsDetail> implements IBbsUserPointsDetailService {

    @Resource
    private BbsUserPointsDetailMapper bbsUserPointsDetailMapper;


    /**
     * 查询用户积分明细
     *
     * @param userName 用户名
     * @return 积分明细
     */
    @Override
    public List<BbsUserPointsDetail> getUserPointsDetail(String userName) {
        return this.list(
            Wrappers.lambdaQuery(BbsUserPointsDetail.class)
                .eq(BbsUserPointsDetail::getUserName, userName)
        );
    }


    /**
     * 添加用户积分明细
     *
     * @param detail 积分明细
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void addUsrePointsDetail(BbsUserPointsDetail detail) {
        BbsUserPointsDetail addDetail = new BbsUserPointsDetail();
        addDetail.setUserName(detail.getUserName());
        addDetail.setDetailName(detail.getDetailName());
        addDetail.setDetailCode(detail.getDetailCode());
        addDetail.setDetailPoints(detail.getDetailPoints());
        addDetail.setBeforePoints(detail.getBeforePoints());
        addDetail.setAfterPoints(detail.getAfterPoints());
        addDetail.setDescription(detail.getDescription());
        this.save(addDetail);
    }

}
