package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsPointsGoods;

import java.util.List;

/**
 * 积分商品Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsPointsGoodsService extends IService<BbsPointsGoods> {

    /**
     * 查询积分商品列表
     *
     * @param bbsPointsGoods 积分商品
     * @return 积分商品集合
     */
    List<BbsPointsGoods> selectBbsPointsGoodsList(BbsPointsGoods bbsPointsGoods);


    /**
     * 添加积分商品
     *
     * @param goods 积分商品
     */
    void addGoods(BbsPointsGoods goods);


    /**
     * 修改积分商品
     *
     * @param goods 积分商品
     */
    void editGoods(BbsPointsGoods goods);


    /**
     * 删除积分商品
     *
     * @param goodsId 积分商品Id
     */
    void deleteGoods(Long goodsId);

}
