package com.tangguo.service;

import java.util.List;
import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsTopic;

/**
 * 话题Service接口
 *
 * @author ruoyi
 * @date 2025-08-27
 */
public interface IBbsTopicService extends IService<BbsTopic> {

    /**
     * 查询话题列表
     *
     * @param bbsTopic 话题
     * @return 话题集合
     */
    List<BbsTopic> selectBbsTopicList(BbsTopic bbsTopic);


    /**
     * 新增话题
     *
     * @param topic 话题
     */
    void addTopic(BbsTopic topic);


    /**
     * 修改话题
     *
     * @param topic 话题
     */
    void editeTopic(BbsTopic topic);


    /**
     * 置顶话题
     *
     * @param topic 话题
     */
    void topTopic(BbsTopic topic);


    /**
     * 删除话题
     *
     * @param topicId 话题Id
     */
    void deleteTopic(Long topicId);

}
