package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 积分规则配置对象 bbs_points_setting
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_points_setting")
@ApiModel(value = "BbsPointsSetting", description = "积分规则配置实体")
public class BbsPointsSetting extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 设置类型：ADD 增加积分、DEC 减少积分 */
	@Excel(name = "设置类型：ADD 增加积分、DEC 减少积分")
	@ApiModelProperty("设置类型：ADD 增加积分、DEC 减少积分")
	private String type;

	/** 应用名称 */
	@Excel(name = "应用名称")
	@ApiModelProperty("应用名称")
	private String agentName;

	/** 应用ID */
	@Excel(name = "应用ID")
	@ApiModelProperty("应用ID")
	private String agentId;

	/** 行为名称 */
	@Excel(name = "行为名称")
	@ApiModelProperty("行为名称")
	private String operateName;

	/** 行为编码 */
	@Excel(name = "行为编码")
	@ApiModelProperty("行为编码")
	private String operateCode;

	/** 行为积分 */
	@Excel(name = "行为积分")
	@ApiModelProperty("行为积分")
	private Integer operatePoints;

	/** 行为上限次数（周） */
	@Excel(name = "行为上限次数", readConverterExp = "周=")
	@ApiModelProperty("行为上限次数（周）")
	private Integer limitCount;

	/** 启用状态：0 禁用、1 启用 */
	@Excel(name = "启用状态：0 禁用、1 启用")
	@ApiModelProperty("启用状态：0 禁用、1 启用")
	private Integer enableStatus;

}
