package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.domain.BbsGrade;
import com.tangguo.service.IBbsGradeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户等级Controller
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Api(tags = "用户等级管理")
@RestController
@RequestMapping("/bbs/moment/grade")
public class BbsGradeController extends BaseController {

	@Resource
	private IBbsGradeService bbsGradeService;


	/**
	 * 查询用户等级列表
	 */
	@ApiOperation("查询用户等级列表")
	@PreAuthorize("@ss.hasPermi('grade:grade:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsGrade bbsGrade) {
		startPage();
		List<BbsGrade> list = bbsGradeService.selectBbsGradeList(bbsGrade);
		return getDataTable(list);
	}


	/**
	 * 获取用户等级详细信息
	 */
	@ApiOperation("获取用户等级详细信息")
	@PreAuthorize("@ss.hasPermi('grade:grade:query')")
	@GetMapping(value = "/{id}")
	public AjaxResult getInfo(@PathVariable("id") Long id) {
		return success(bbsGradeService.getById(id));
	}


	/**
	 * 新增用户等级
	 */
	@ApiOperation("新增用户等级")
	@PreAuthorize("@ss.hasPermi('grade:grade:add')")
	@Log(title = "用户等级", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody BbsGrade grade) {
		this.bbsGradeService.addGrade(grade);
		return AjaxResult.success();
	}


	/**
	 * 修改用户等级
	 */
	@ApiOperation("修改用户等级")
	@PreAuthorize("@ss.hasPermi('grade:grade:edit')")
	@Log(title = "用户等级", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody BbsGrade grade) {
		this.bbsGradeService.editGrade(grade);
		return AjaxResult.success();
	}


	/**
	 * 删除用户等级
	 */
	@ApiOperation("删除用户等级")
	@PreAuthorize("@ss.hasPermi('grade:grade:remove')")
	@Log(title = "用户等级", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
	public AjaxResult remove(@PathVariable Long id) {
		this.bbsGradeService.deleteGrade(id);
		return AjaxResult.success();
	}

}
