import request from '@/utils/request'

// 动态列表
export function listData(params) {
    return request({
        url: '/bbs/moment/list',
        method: 'get',
        params
    })
}

// 动态详情
export function detailData(id) {
    return request({
        url: `/bbs/moment/${id}`,
        method: 'get'
    })
}


// 删除动态
export function delData(id) {
    return request({
        url: `/bbs/moment/${id}`,
        method: 'delete'
    })
}

// 动态评论
export function getMomentComments(momentId, params) {
    return request({
        url: `/bbs/moment/comment/moment/${momentId}`,
        method: 'get',
        params
    })
}

// 置顶取消置顶
export function isTopData(data){
    return request({
        url:`/bbs/moment/top`,
        method:'put',
        data
    })
}