package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.domain.BbsMoment;
import com.tangguo.service.IBbsMomentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 动态Controller
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Api(tags="动态管理")
@RestController
@RequestMapping("/points/points")
public class BbsMomentController extends BaseController {

    @Resource
    private IBbsMomentService bbsMomentService;


    /**
     * 查询动态列表
     */
    @ApiOperation("查询动态列表")
    @PreAuthorize("@ss.hasPermi('points:points:list')")
    @GetMapping("/list")
    public TableDataInfo list(BbsMoment bbsMoment) {
        startPage();
        List<BbsMoment> list = bbsMomentService.selectBbsMomentList(bbsMoment);
        return getDataTable(list);
    }


    /**
     * 删除动态
     */
    @ApiOperation("删除动态")
    @PreAuthorize("@ss.hasPermi('points:points:remove')")
    @Log(title = "动态", businessType = BusinessType.DELETE)
	@DeleteMapping("/{id}")
    public AjaxResult remove(@PathVariable Long id) {
        return toAjax(bbsMomentService.removeById(id));
    }

}
