package com.tangguo.common.mauth;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.time.Duration;

/**
 * 移动端用户Token配置参数
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@Getter
@Setter
@Component
@ConfigurationProperties(prefix = "mobile.auth")
public class MobileProperties {

    /**
     * 生成时Token参数名
     */
    private String resTokenName;

    /**
     * 请求时Token参数名
     */
    private String reqTokenName;

    /**
     * Token签发人
     */
    private String issuer = "MobileAuth";

    /**
     * Token签名算法
     */
    private String algorithmId = "HS512";

    /**
     * Token签名密钥
     */
    private String signKey = "SignKey2025@.";

    /**
     * Token有效时间
     */
    private Duration effectiveTime = Duration.ofDays(7);

    /**
     * 拦截器拦截路径
     */
    private String[] pathPatterns = {"/mobile/**"};

}
