import request from '@/utils/request'

// 用户等级列表
export function listData(params) {
    return request({
        url: '/bbs/points/grade/list',
        method: 'get',
        params
    })
}

// 用户等级详情
export function detailData(id) {
    return request({
        url: `/bbs/points/grade/${id}`,
        method: 'get'
    })
}

// 新增用户等级
export function addData(data) {
    return request({
        url: '/bbs/points/grade',
        method: 'post',
        data
    })
}

// 修改用户等级
export function editData(data) {
    return request({
        url: '/bbs/points/grade',
        method: 'put',
        data
    })
}


// 删除用户等级
export function delData(id) {
    return request({
        url: `/bbs/points/grade/${id}`,
        method: 'delete'
    })
}

// 修改初始等级
export function editInitialLevel(data){
     return request({
        url: `/bbs/points/grade/initial`,
        method:'put',
        data
     })
}