package com.tangguo.controller;

import com.tangguo.common.annotation.Log;
import com.tangguo.common.annotation.RepeatSubmit;
import com.tangguo.common.core.controller.BaseController;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.enums.BusinessType;
import com.tangguo.common.utils.poi.ExcelUtil;
import com.tangguo.domain.BbsUserPointsExchange;
import com.tangguo.domain.bo.UserPointsExchangeBO;
import com.tangguo.service.IBbsUserPointsExchangeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 用户积分兑换Controller
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Api(tags = "用户积分兑换管理")
@RestController
@RequestMapping("/bbs/points/exchange")
public class BbsUserPointsExchangeController extends BaseController {

	@Resource
	private IBbsUserPointsExchangeService bbsUserPointsExchangeService;


	/**
	 * 查询用户积分兑换列表
	 */
	@ApiOperation("查询用户积分兑换列表")
	@PreAuthorize("@ss.hasPermi('points:exchange:list')")
	@GetMapping("/list")
	public TableDataInfo list(BbsUserPointsExchange exchange) {
		startPage();
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(exchange);
		return getDataTable(list);
	}


	/**
	 * 导出用户积分列表
	 */
	@ApiOperation("导出用户积分列表")
	@PreAuthorize("@ss.hasPermi('points:exchange:export')")
	@Log(title = "用户积分", businessType = BusinessType.EXPORT)
	@PostMapping("/export")
	public void export(HttpServletResponse response, BbsUserPointsExchange exchange) {
		List<BbsUserPointsExchange> list = bbsUserPointsExchangeService.selectBbsUserPointsExchangeList(exchange);
		ExcelUtil<BbsUserPointsExchange> util = new ExcelUtil<>(BbsUserPointsExchange.class);
		util.exportExcel(response, list, "用户积分数据");
	}


	/**
	 * 用户积分兑换
	 */
	@RepeatSubmit(interval = 1000)
	@ApiOperation("用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:exchange:exchange')")
	@Log(title = "用户积分兑换", businessType = BusinessType.INSERT)
	@PostMapping("/exchange")
	public AjaxResult exchange(@RequestBody BbsUserPointsExchange exchange) {
		this.bbsUserPointsExchangeService.addUserPointsExchange(exchange);
		return AjaxResult.success();
	}


	/**
	 * 用户积分兑换
	 */
	@RepeatSubmit(interval = 1000)
	@ApiOperation("用户积分兑换")
	@PreAuthorize("@ss.hasPermi('points:exchange:exchange')")
	@Log(title = "用户积分兑换", businessType = BusinessType.INSERT)
	@PostMapping("/batch/exchange")
	public AjaxResult batchExchange(@RequestBody UserPointsExchangeBO bo) {
		List<Map<String, String>> results = this.bbsUserPointsExchangeService.batchAddUserPointsExchange(bo);
		return AjaxResult.success(results);
	}

}
