package com.tangguo.listener;

import com.tangguo.common.constant.ActiveMQConstant;
import com.tangguo.common.domain.OperateDetail;
import com.tangguo.service.IBbsPointsSettingService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.jms.Message;

/**
 * 用户操作事件监听器
 *
 * @author 谈笑
 * @createTime 2025-09-01 16:03:08 星期一
 */
@Slf4j
@Component
public class OperateListener {

	@Resource
	private IBbsPointsSettingService pointsSettingService;


	/**
	 * 处理用户操作积分消息
	 *
	 * @param detail 操作明细
	 */
	@JmsListener(destination = ActiveMQConstant.Operate.USER_OPERATE, containerFactory = ActiveMQConstant.QUEUE_CONTAINER_BEAN)
	public void handleOperatePoints(OperateDetail detail, Message message) {
		try {
			log.info("=> 开始处理用户操作积分消息：{}", detail);
			this.pointsSettingService.handleOperatePoints(detail);
			message.acknowledge();
		} catch (Exception e) {
			log.error("=> 用户操作积分消息处理失败，操作明细：{} 错误信息：", detail, e);
		}
	}

}
