package com.tangguo.domain.bo;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 *
 *
 * @author 谈笑
 * @createTime 2025-09-05 11:58:28 星期五
 */
@Data
public class FeaturedCommentBO {

	/**
	 * 动态Id
	 */
	@NotNull(message = "动态Id不能为空")
	private Long momentId;

	/**
	 * 评论Id
	 */
	@NotNull(message = "评论Id不能为空")
	private Long commentId;

	/**
	 * 精选状态：0 取消精选、1 精选
	 */
	@NotNull(message = "精选状态不能为空")
	@Min(value = 0, message = "精选状态值错误")
	@Max(value = 1, message = "精选状态值错误")
	private Integer featuredStatus;

}
