package com.tangguo.controller.mobile;

import com.tangguo.common.config.RuoYiConfig;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.utils.ServerConfigUtils;
import com.tangguo.common.utils.file.FileUploadUtils;
import com.tangguo.common.utils.file.FileUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;


/**
 * 移动端通用控制器
 *
 * @author 谈笑
 * @createTime 2025-09-03 16:51:34 星期三
 */
@RestController
@RequestMapping("/bbs/mobile/common")
public class MBbsCommonController {

	/**
	 * 通用上传请求（单个）
	 */
	@PostMapping("/upload")
	public AjaxResult uploadFile(MultipartFile file) {
		try {
			// 上传文件路径
			String filePath = RuoYiConfig.getUploadPath();
			// 上传并返回新文件名称
			String fileName = FileUploadUtils.upload(filePath, file);
			String url = ServerConfigUtils.getUrl() + fileName;
			AjaxResult ajax = AjaxResult.success();
			ajax.put("url", url);
			ajax.put("fileName", fileName);
			ajax.put("newFileName", FileUtils.getName(fileName));
			ajax.put("originalFilename", file.getOriginalFilename());
			return ajax;
		} catch (Exception e) {
			return AjaxResult.error(e.getMessage());
		}
	}

}
