package com.tangguo.common.utils;

import javax.servlet.http.HttpServletRequest;

public class ServerConfigUtils {
	public static String getDomain(HttpServletRequest request) {
		StringBuffer url = request.getRequestURL();
		String contextPath = request.getServletContext().getContextPath();
		return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
	}

	/**
	 * 获取完整的请求路径，包括：域名，端口，上下文访问路径
	 *
	 * @return 服务地址
	 */
	public static String getUrl() {
		HttpServletRequest request = ServletUtils.getRequest();
		return getDomain(request);
	}
}
