package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentVote;
import com.tangguo.domain.vo.BbsVoteVO;

import java.util.List;

/**
 * 动态投票记录Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentVoteService extends IService<BbsMomentVote> {

	/**
	 * 查询用户投票记录数量
	 *
	 * @param momentId 动态Id
	 * @param userName 用户名
	 * @return 点赞记录
	 */
	long getUserMomentVoteCount(Long momentId, String userName);


	/**
	 * 添加点赞记录
	 *
	 * @param momentId 动态Id
	 * @param userName 用户名
	 * @param optionCode 投票选项编码
	 */
	void addMomentVoteCount(Long momentId, String userName, String optionCode);


	/**
	 * 查询投票记录列表
	 *
	 * @param momentId 动态Id
	 * @param optionCode 投票选项编码
	 * @return 投票记录
	 */
	List<BbsVoteVO> getMomentVotes(Long momentId, String optionCode);

}
