package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.mauth.MobileAuth;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.service.IBbsMomentService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 移动端动态控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 16:19:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/moment")
public class MBbsMomentController {

	@Resource
	private IBbsMomentService momentService;


	/**
	 * 创建动态
	 *
	 * @param bo 动态
	 * @return 创建结果
	 */
	@MobileAuth
	@PostMapping("/create")
	public AjaxResult createMoment(@RequestBody CreateMomentBO bo) {
		this.momentService.userCreateMoment(bo);
		return AjaxResult.success();
	}


	/**
	 * 删除动态
	 *
	 * @param momentId 动态Id
	 * @return 删除结果
	 */
	@MobileAuth
	@DeleteMapping("/delete/{momentId}")
	public AjaxResult createMoment(@PathVariable Long momentId) {
		this.momentService.userDeleteMoment(momentId);
		return AjaxResult.success();
	}

}
