package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 用户积分明细对象 bbs_user_points_detail
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_user_points_detail")
@ApiModel(value = "BbsUserPointsDetail", description = "用户积分明细实体")
public class BbsUserPointsDetail extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 用户名 */
	@Excel(name = "用户名")
	@ApiModelProperty("用户名")
	private String userName;

	/** 明细名称 */
	@Excel(name = "明细名称")
	@ApiModelProperty("明细名称")
	private String detailName;

	/** 明细编码 */
	@Excel(name = "明细编码")
	@ApiModelProperty("明细编码")
	private String detailCode;

	/** 明细积分 */
	@Excel(name = "明细积分")
	@ApiModelProperty("明细积分")
	private Integer detailPoints;

	/** 计算前积分 */
	@Excel(name = "计算前积分")
	@ApiModelProperty("计算前积分")
	private Integer beforePoints;

	/** 计算后积分 */
	@Excel(name = "计算后积分")
	@ApiModelProperty("计算后积分")
	private Integer afterPoints;

	/** 积分明细描述 */
	@Excel(name = "积分明细描述")
	@ApiModelProperty("积分明细描述")
	private String description;

}
