import request from '@/utils/request'

// 敏感词列表
export function listData(params) {
    return request({
        url: '/bbs/moment/sensitive/word/list',
        method: 'get',
        params
    })
}

// 敏感词详情
export function detailData(id) {
    return request({
        url: `/bbs/moment/sensitive/word/${id}`,
        method: 'get'
    })
}

// 新增敏感词
export function addData(data) {
    return request({
        url: '/bbs/moment/sensitive/word',
        method: 'post',
        data
    })
}

// 修改敏感词
export function editData(data) {
    return request({
        url: '/bbs/moment/sensitive/word',
        method: 'put',
        data
    })
}

// 刷新敏感词缓存
export function refresh(data) {
    return request({
        url: '/bbs/moment/sensitive/word/refresh',
        method: 'put',
        data
    })
}

// 删除敏感词
export function delData(id) {
    return request({
        url: `/bbs/moment/sensitive/word/${id}`,
        method: 'delete'
    })
}

// 导入敏感词
export function importWords(data){
    return request({
        url: '/bbs/moment/sensitive/word/import',
        method: 'post',
        data
    })
}