package com.tangguo.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 动态选项投票类型
 *
 * @author 谈笑
 * @createTime 2025-09-03 17:11:39 星期三
 */
@Getter
@AllArgsConstructor
public enum VoteOptionType {

	TEXT("文本投票"), IMAGE("图片投票");

	private final String desc;


	public static VoteOptionType getVoteOptionType(String type) {
		return Arrays.stream(VoteOptionType.values())
			.filter(t -> t.name().equals(type)).findFirst().orElse(null);
	}

}
