package com.tangguo.listener;

import com.tangguo.common.constant.ActiveMQConstant;
import com.tangguo.domain.dto.PointsDetail;
import com.tangguo.service.IBbsUserPointsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.jms.Message;

/**
 * 用户积分增加扣减消息时间监听器
 *
 * @author 谈笑
 * @createTime 2025-09-01 16:03:08 星期一
 */
@Slf4j
@Component
public class UserPointsListener {

	@Resource
	private IBbsUserPointsService userPointsService;


	/**
	 * 增加用户积分消息
	 *
	 * @param detail 积分明细
	 */
	@JmsListener(destination = ActiveMQConstant.Points.INCR_USER_POINTS_QUEUE, containerFactory = ActiveMQConstant.QUEUE_CONTAINER_BEAN)
	public void incrUserPointsListener(PointsDetail detail, Message message) {
		try {
			log.info("=> 开始处理增加用户积分消息：{}", detail);
			this.userPointsService.incrUserPoints(detail);
			message.acknowledge();
		} catch (Exception e) {
			log.error("=> 增加用户积分消息处理失败，积分明细：{} 错误信息：", detail, e);
		}
	}


	/**
	 * 扣减用户积分消息
	 *
	 * @param detail 积分明细
	 */
	@JmsListener(destination = ActiveMQConstant.Points.DECR_USER_POINTS_QUEUE, containerFactory = ActiveMQConstant.QUEUE_CONTAINER_BEAN)
	public void decrUserPointsListener(PointsDetail detail, Message message) {
		try {
			log.info("=> 扣减用户积分消息：{}", detail);
			this.userPointsService.decrUserPoints(detail);
			message.acknowledge();
		} catch (Exception e) {
			log.error("=> 扣减用户积分消息处理失败，积分明细：{} 错误信息：", detail, e);
		}
	}

}
