package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 动态点赞记录对象 bbs_moment_like
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_moment_like")
@ApiModel(value = "BbsMomentLike", description = "动态点赞记录实体")
public class BbsMomentLike extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 动态ID */
	@Excel(name = "动态ID")
	@ApiModelProperty("动态ID")
	private Long momentId;

	/** 点赞用户名 */
	@Excel(name = "点赞用户名")
	@ApiModelProperty("点赞用户名")
	private String userName;

	/** 点赞状态：0 取消、1 正常 */
	@Excel(name = "点赞状态：0 取消、1 正常")
	@ApiModelProperty("点赞状态：0 取消、1 正常")
	private Integer likeStatus;

}
