package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.domain.bo.CodeLoginBO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 动态用户管理控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/user")
public class BbsUserController {

	/**
	 * 企微用户Code登录
	 *
	 * @param bo 登录参数
	 * @return 登录结果
	 */
	@PostMapping("/code/login")
	public AjaxResult codeLogin(@RequestBody CodeLoginBO bo) {
		return AjaxResult.success();
	}


	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@PostMapping("/profile")
	public AjaxResult profile() {
		return AjaxResult.success();
	}

}
