package com.tangguo.framework.mauth;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 移动端Web配置
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RequiredArgsConstructor
@Configuration
public class MobileWebMvcConfig implements WebMvcConfigurer {

	private final MobileProperties mobileProperties;

	private final MobileAuthInterceptor mobileAuthInterceptor;


	/**
	 * 自定义拦截规则
	 */
	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(this.mobileAuthInterceptor).addPathPatterns(this.mobileProperties.getPathPatterns());
	}

}
