package com.tangguo.framework.mauth;

import lombok.Getter;

/**
 * 移动端用户鉴权失败异常类
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@Getter
public class Mobile403Exception extends RuntimeException {

	private static final long serialVersionUID = 4027402152375922779L;

	/**
	 * 状态码
	 */
	private final int code = 403;

	/**
	 * 异常消息
	 */
	private final String message;


	public Mobile403Exception(String message) {
		this.message = message;
	}


	public Mobile403Exception(String message, Throwable cause) {
		super(message, cause);
		this.message = message;
	}

}
