package com.tangguo.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.mapper.BbsMomentCommentMapper;
import com.tangguo.service.IBbsMomentCommentService;
import org.springframework.stereotype.Service;
import java.util.List;

import javax.annotation.Resource;

/**
 * 动态评论记录Service业务层处理
 *
 * @author ruoyi
 * @date 2025-08-28
 */
@Service
public class BbsMomentCommentServiceImpl extends ServiceImpl<BbsMomentCommentMapper, BbsMomentComment> implements IBbsMomentCommentService {

    @Resource
    private BbsMomentCommentMapper bbsMomentCommentMapper;


    /**
     * 查询动态评论记录列表
     *
     * @param comment 动态评论记录
     * @return 动态评论记录
     */
    @Override
    public List<BbsMomentComment> selectBbsMomentCommentList(BbsMomentComment comment) {
        return this.baseMapper.selectComments(comment);
    }

}
