package com.tangguo.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangguo.common.annotation.Excel;
import com.tangguo.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * 用户积分兑换对象 bbs_user_points_exchange
 *
 * @author ruoyi
 * @date 2025-08-29
 */
@Data
@ToString
@NoArgsConstructor
@Accessors(chain = true)
@TableName("bbs_user_points_exchange")
@ApiModel(value = "BbsUserPointsExchange", description = "用户积分兑换实体")
public class BbsUserPointsExchange extends BaseEntity {
	private static final long serialVersionUID = 1L;

	/** ID */
	@TableId(type = IdType.AUTO)
	@ApiModelProperty("ID")
	private Long id;

	/** 用户姓名 */
	@Excel(name = "用户姓名")
	@ApiModelProperty("用户姓名")
	private String nikeName;

	/** 用户名 */
	@Excel(name = "用户名")
	@ApiModelProperty("用户名")
	private String userName;

	/** 用户等级名称 */
	@Excel(name = "用户等级名称")
	@ApiModelProperty("用户等级名称")
	private String userGradeName;

	/** 商品名称 */
	@Excel(name = "商品名称")
	@ApiModelProperty("商品名称")
	private String goodsName;

	/** 商品编码 */
	@Excel(name = "商品编码")
	@ApiModelProperty("商品编码")
	private String goodsCode;

	/** 商品兑换积分 */
	@Excel(name = "商品兑换积分")
	@ApiModelProperty("商品兑换积分")
	private Integer goodsExchangePoints;

	/** 用户剩余积分 */
	@Excel(name = "用户剩余积分")
	@ApiModelProperty("用户剩余积分")
	private Integer userRemainingPoints;

}
