package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsUserPointsExchange;
import com.tangguo.domain.bo.UserPointsExchangeBO;

import java.util.List;
import java.util.Map;

/**
 * 用户积分兑换Service接口
 *
 * @author ruoyi
 * @date 2025-08-29
 */
public interface IBbsUserPointsExchangeService extends IService<BbsUserPointsExchange> {

    /**
     * 查询用户积分兑换列表
     *
     * @param bbsUserPointsExchange 用户积分兑换
     * @return 用户积分兑换集合
     */
    List<BbsUserPointsExchange> selectBbsUserPointsExchangeList(BbsUserPointsExchange bbsUserPointsExchange);


    /**
     * 用户积分兑换
     *
     * @param exchange 兑换
     */
    void addUserPointsExchange(BbsUserPointsExchange exchange);


	/**
	 * 批量用户积分兑换
	 *
	 * @param bo 兑换
	 */
	List<Map<String, String>> batchAddUserPointsExchange(UserPointsExchangeBO bo);

}
