package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMomentComment;
import com.tangguo.domain.bo.BbsCommentTopBO;
import com.tangguo.domain.vo.BbsCommentDetailVO;

import java.util.List;

/**
 * 动态评论记录Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsMomentCommentService extends IService<BbsMomentComment> {

    /**
     * 查询动态评论记录列表
     *
     * @param comment 动态评论记录
     * @return 动态评论记录集合
     */
    List<BbsMomentComment> selectBbsMomentCommentList(BbsMomentComment comment);


    /**
     * 查询动态评论记录详情
     *
     * @param commentId 动态评论记录Id
     * @return 动态评论记录详情
     */
    BbsMomentComment getBbsMomentComment(Long commentId);


    /**
     * 查询动态评论
     *
     * @param momentId 动态Id
     * @return 投票选项
     */
    List<BbsMomentComment> getMomentComments(Long momentId);


    /**
     * 查询动态评论
     *
     * @param momentIds 动态Ids
     * @param userName 用户名
     * @return 投票选项
     */
    List<BbsMomentComment> getMomentLimitComments(List<Long> momentIds, String userName);


    /**
     * 查询动态评论
     *
     * @param momentId 动态Id
     * @param userName 用户名
     * @return 评论
     */
    List<BbsCommentDetailVO> getMomentComments(Long momentId, String userName);


    /**
     * 删除动态评论记录
     *
     * @param momentId 动态Id
     */
    void deleteMomentComments(Long momentId);


	/**
	 * 置顶评论
	 *
	 * @param bo 请求参数
	 */
	void topMomentComment(BbsCommentTopBO bo);

}
