package com.tangguo.framework.security.handle;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSON;
import com.tangguo.common.constant.HttpStatus;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.utils.ServletUtils;
import com.tangguo.common.utils.StringUtils;
import com.tangguo.framework.config.ServerConfig;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.cp.api.WxCpOAuth2Service;
import me.chanjar.weixin.cp.api.WxCpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

/**
 * 认证失败处理类 返回未授权
 *
 * @author ruoyi
 */
@Slf4j
@Component
public class AuthenticationEntryPointImpl implements AuthenticationEntryPoint, Serializable {
	private static final long serialVersionUID = -8970718410437077606L;

	@Autowired
	private WxCpService mobileWxCpService;

	@Value("${wx.cp.mobile-redirect-url}")
	private String mobileRedirectUrl;

	@Override
	public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e)
			throws IOException {
		String uri = request.getRequestURI();
		int code = HttpStatus.UNAUTHORIZED;

		log.info("=> 身份认证失败，Token：{}", request.getHeader("Authorization"));

		if (uri.startsWith("/bbs/mobile")) {
			WxCpOAuth2Service oauth2Service = this.mobileWxCpService.getOauth2Service();
			String oauth2Url = oauth2Service.buildAuthorizationUrl(this.mobileRedirectUrl, null);
			ServletUtils.renderString(response, JSON.toJSONString(AjaxResult.error(401, "身份认证失败", oauth2Url)));
		} else {
			String msg = StringUtils.format("请求访问：{}，认证失败，无法访问系统资源", uri);
			ServletUtils.renderString(response, JSON.toJSONString(AjaxResult.error(code, msg)));
		}
	}
}
