package com.tangguo.controller.mobile;

import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.page.TableDataInfo;
import com.tangguo.common.utils.PageUtils;
import com.tangguo.common.utils.SecurityUtils;
import com.tangguo.domain.vo.BbsMomentListVO;
import com.tangguo.domain.vo.BbsUserMomentCountVO;
import com.tangguo.service.IBbsMomentService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 移动端用户控制器
 *
 * @author 谈笑
 * @createTime 2025-09-02 14:42:17 星期二
 */
@RestController
@RequestMapping("/bbs/mobile/user")
public class MBbsUserController {

	@Resource
	private IBbsMomentService momentService;


	/**
	 * 查询用户动态统计
	 *
	 * @return 动态统计
	 */
	@GetMapping("/moment/count")
	public AjaxResult getUserMomentCount() {
		String username = SecurityUtils.getUsername();
		BbsUserMomentCountVO momentCount = this.momentService.getUserMomentCount(username);
		return AjaxResult.success(momentCount);
	}


	/**
	 * 查询用户动态列表
	 *
	 * @return 动态
	 */
	@GetMapping("/moments")
	public TableDataInfo getUserMoments(String content) {
		String username = SecurityUtils.getUsername();
		PageUtils.clearPage();
		List<BbsMomentListVO> moments = this.momentService.getUserMoments(username, content);
		return TableDataInfo.getDataTable(moments);
	}

}
