package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.common.domain.PointsDetail;
import com.tangguo.domain.BbsUserPoints;

import java.util.List;

/**
 * 用户积分Service接口
 *
 * @author ruoyi
 * @date 2025-08-29
 */
public interface IBbsUserPointsService extends IService<BbsUserPoints> {

    /**
     * 查询用户积分列表
     *
     * @param bbsUserPoints 用户积分
     * @return 用户积分集合
     */
     List<BbsUserPoints> selectBbsUserPointsList(BbsUserPoints bbsUserPoints);


    /**
     * 查询用户积分
     *
     * @param userName 用户名
     * @return 积分
     */
     BbsUserPoints getUserPoints(String userName);


    /**
     * 查询用户积分
     *
     * @param userName 用户名
     * @return 积分
     */
     BbsUserPoints getAndInitUserPoints(String userName);


    /**
     * 增加用户积分
     *
     * @param points 积分
     */
    void addUserPoints(BbsUserPoints points);


    /**
     * 扣减用户积分
     *
     * @param points 积分
     */
    void deleteUserPoints(BbsUserPoints points);


    /**
     * 增加用户积分
     *
     * @param detail 积分明细
     */
    void incrUserPoints(PointsDetail detail);


    /**
     * 扣减用户积分
     *
     * @param detail 积分明细
     */
    void decrUserPoints(PointsDetail detail);

}
