package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsMoment;
import com.tangguo.domain.BbsMomentVoteOption;
import com.tangguo.domain.bo.CreateMomentBO;
import com.tangguo.domain.vo.BbsVoteOptionVO;

import java.util.List;

/**
 * 动态投票选项Service接口
 *
 * @author ruoyi
 * @date 2025-09-01
 */
public interface IBbsMomentVoteOptionService extends IService<BbsMomentVoteOption> {

	/**
	 * 查询动态投票选项
	 *
	 * @param momentId 动态Id
	 * @return 投票选项
	 */
	List<BbsMomentVoteOption> getVoteOptions(Long momentId);


	/**
	 * 查询动态投票选项
	 *
	 * @param momentIds 动态Ids
	 * @return 投票选项
	 */
	List<BbsMomentVoteOption> getVoteOptions(List<Long> momentIds);


	/**
	 * 添加动态投票选项
	 *
	 * @param moment 动态
	 * @param voteOptions 投票选项
	 */
	void addVoteOptions(BbsMoment moment, List<CreateMomentBO.VoteOption> voteOptions);


	/**
	 * 删除动态投票选项
	 *
	 * @param momentId 动态Id
	 */
	void deleteVoteOptions(Long momentId);


	/**
	 * 查询投票选项
	 *
	 * @param momentId 动态Id
	 * @param optionCode 投票选项编码
	 * @return 投票选项
	 */
	BbsMomentVoteOption getVoteOption(Long momentId, String optionCode);


	/**
	 * 查询动态投票选项统计
	 *
	 * @param momentId 动态Id
	 * @return 投票选项统计
	 */
	List<BbsVoteOptionVO> getVoteOptionCount(Long momentId);

}
