package com.tangguo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.tangguo.domain.BbsGrade;

import java.util.List;

/**
 * 用户等级Service接口
 *
 * @author ruoyi
 * @date 2025-08-28
 */
public interface IBbsGradeService extends IService<BbsGrade> {

    /**
     * 查询用户等级列表
     *
     * @param bbsGrade 用户等级
     * @return 用户等级集合
     */
    List<BbsGrade> selectBbsGradeList(BbsGrade bbsGrade);


    /**
     * 新增等级
     *
     * @param grade 等级
     */
    void addGrade(BbsGrade grade);


    /**
     * 修改等级
     *
     * @param grade 等级
     */
    void editGrade(BbsGrade grade);


    /**
     * 修改等级初始值
     *
     * @param grade 等级
     */
    void editGradeInitial(BbsGrade grade);


    /**
     * 删除等级
     *
     * @param gradeId 等级Id
     */
    void deleteGrade(Long gradeId);

}
