package com.tangguo.web.controller.system;

import com.tangguo.common.constant.Constants;
import com.tangguo.common.core.domain.AjaxResult;
import com.tangguo.common.core.domain.entity.SysMenu;
import com.tangguo.common.core.domain.entity.SysUser;
import com.tangguo.common.core.domain.model.LoginBody;
import com.tangguo.common.utils.SecurityUtils;
import com.tangguo.common.core.domain.model.WxcpCodeLogin;
import com.tangguo.framework.web.service.SysLoginService;
import com.tangguo.framework.web.service.SysPermissionService;
import com.tangguo.system.service.ISysMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 登录验证
 *
 * @author ruoyi
 */
@RestController
public class SysLoginController {
	@Autowired
	private SysLoginService loginService;

	@Autowired
	private ISysMenuService menuService;

	@Autowired
	private SysPermissionService permissionService;

	/**
	 * 登录方法
	 *
	 * @param loginBody 登录信息
	 * @return 结果
	 */
	@PostMapping("/login")
	public AjaxResult login(@RequestBody LoginBody loginBody) {
		AjaxResult ajax = AjaxResult.success();
		// 生成令牌
		String token = loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(),
				loginBody.getUuid());
		ajax.put(Constants.TOKEN, token);
		return ajax;
	}

	/**
	 * 获取用户信息
	 *
	 * @return 用户信息
	 */
	@GetMapping("getInfo")
	public AjaxResult getInfo() {
		SysUser user = SecurityUtils.getLoginUser().getUser();
		// 角色集合
		Set<String> roles = permissionService.getRolePermission(user);
		// 权限集合
		Set<String> permissions = permissionService.getMenuPermission(user);
		AjaxResult ajax = AjaxResult.success();
		ajax.put("user", user);
		ajax.put("roles", roles);
		ajax.put("permissions", permissions);
		return ajax;
	}

	/**
	 * 获取路由信息
	 *
	 * @return 路由信息
	 */
	@GetMapping("getRouters")
	public AjaxResult getRouters() {
		Long userId = SecurityUtils.getUserId();
		List<SysMenu> menus = menuService.selectMenuTreeByUserId(userId);
		return AjaxResult.success(menuService.buildMenus(menus));
	}




	/**
	 * 企微用户Code登录
	 *
	 * @param bo 登录参数
	 * @return 登录结果
	 */
	@PostMapping("/bbs/mobile/user/code/login")
	public AjaxResult codeLogin(@RequestBody WxcpCodeLogin bo) {
		Map<String, Object> tokenMap = this.loginService.codeLogin(bo);
		return AjaxResult.success(tokenMap);
	}


	/**
	 * 查询用户信息
	 *
	 * @return 用户信息
	 */
	@GetMapping("/bbs/mobile/user/profile")
	public AjaxResult getUserProfile() {
		SysUser sysUser = SecurityUtils.getLoginUser().getUser();
		return AjaxResult.success(sysUser);
	}

}
