package com.tangguo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tangguo.domain.BbsMomentLike;
import com.tangguo.mapper.BbsMomentLikeMapper;
import com.tangguo.service.IBbsMomentLikeService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 动态点赞记录Service业务层处理
 *
 * @author ruoyi
 * @date 2025-09-01
 */
@Service
public class BbsMomentLikeServiceImpl extends ServiceImpl<BbsMomentLikeMapper, BbsMomentLike> implements IBbsMomentLikeService {

    @Resource
    private BbsMomentLikeMapper bbsMomentLikeMapper;


    /**
     * 查询用户点赞记录数量
     *
     * @param momentId 动态Id
     * @param userName 用户名
     * @return 点赞记录
     */
    @Override
    public long getUserMomentLikeCount(Long momentId, String userName) {
        return this.count(
            Wrappers.lambdaQuery(BbsMomentLike.class)
                .eq(BbsMomentLike::getMomentId, momentId)
                .eq(BbsMomentLike::getUserName, userName)
        );
    }


    /**
     * 添加点赞记录
     *
     * @param momentId 动态Id
     * @param userName 用户名
     */
    @Override
    public void addMomentLike(Long momentId, String userName) {
        BbsMomentLike newLike = new BbsMomentLike();
        newLike.setMomentId(momentId);
        newLike.setUserName(userName);
        this.save(newLike);
    }


    /**
     * 删除点赞记录
     *
     * @param momentId 动态Id
     * @param userName 用户名
     */
    @Override
    public void deleteMomentLike(Long momentId, String userName) {
        this.remove(
            Wrappers.lambdaQuery(BbsMomentLike.class)
                .eq(BbsMomentLike::getMomentId, momentId)
                .eq(BbsMomentLike::getUserName, userName)
        );
    }

}
